// ============================================================================
// |                      MACRO FILE PROTEUS 2.0c                             |
// ============================================================================
//                                     B&C Microsystems Inc. 1993
//
//
MACRO DEMO1
// ----------------------------------------------------------------------------
// This macro selects the manufacturer AMD and the device AM2764. Then it will
// the user to insert the device into the socket. Next it will execute the
// "Load File" command and load the file "file1.dat" into the Edit Buffer.
// The command "Program Device" will be executed then. This command will program
// the selected device with the data loaded into the Edit Buffer.
// Finally the macro will terminate the program and return to PROTEUS-TUTOR.
// ----------------------------------------------------------------------------
key d
prompt Note1: If the slide show runs too slow you can change the Slide Show Speed.
delay \%1
prompt When back to [Execute Sample Operations] run command "Set Slide Show Speed".
delay \%1
prompt Note2: You can also step at any time to the next slide by tapping any key.
delay \%1
prompt Note3: PROTEUS-TUTOR messages are in yellow. Execution messages are in red.
delay \%1
prompt We will now start the operation programming a device with data from a file.
delay \%1
prompt The first thing we need to do is to execute the command "Choose Device".
delay \%1
key c                               // Choose manufacturer AMD
prompt Now we have to select the AMD device manufacturer.
delay \%1
key 01
prompt We need to type <Enter> to bring up AMD's Device List.
delay \%1
key \enter
prompt To select the device AM2764 we will press the DOWN cursor key 3 times.
delay \%1
key \dn \dn \dn                    // Select device AM2764
prompt Now we will tap the <SPACE> bar or type "j" to select the PLCC(J) package.
delay \%1
key j
prompt We will type now <Enter> to select the device and return to the Main Menu.
delay \%1
key \enter
prompt Will execute "Load File" to load data from the file into the Edit Buffer.
delay \%1
key l                               // Read device into Edit Buffer
prompt Here we will type the name of the file that contains our data.
delay \%1
clrfield                            // Clear file name input field
key file1.dat                       // Insert file name FILE1.DAT
prompt Next we will hit <Enter> to start loading the file.
delay \%1
key \enter
prompt Here we can set any desired programming options.
delay \%1
key o                               // Execute Options command
prompt Need to type <ESC> to return to the Main Menu.
delay \%1
key \esc
init autoblank y                    // Init autoblankcheck to y(es)
init autover s                      // Init autoverify to s(tandard)
init autochkins n                   // Init autocheckinsertion to n(o)
init autochkid n                    // Init autocheckid to n(o)
prompt Here you would need to insert the device AM2764 into the socket.
delay \%1
prompt Will execute now command "Program Device" to copy data from buffer to device.
delay \%1
key p
prompt Finally we will type <ESC> to quit.
delay \%1
key \esc
prompt Typing "y" will confirm.
delay \%1
key y
endmac
// ----------------------------------------------------------------------------
 
 
 
MACRO DEMO2
// ----------------------------------------------------------------------------
// This macro selects the manufacturer AMD and device AM2764 and propmts you to
// insert device into socket. It then reads the device contents into the Edit
// Buffer. Next it will save the contents of the Edit Buffer into the file
// "file1.dat" after which it will terminate the program and return the the
// PROTEUS-TUTOR.
// ----------------------------------------------------------------------------
key d
prompt Note1: If the slide show runs too slow you can change the Slide Show Speed.
delay \%1
prompt When back to [Execute Sample Operations] run command "Set Slide Show Speed".
delay \%1
prompt Note2: You can also step at any time to the next slide by tapping any key.
delay \%1
prompt Note3: PROTEUS-TUTOR messages are in yellow. Execution messages are in red.
delay \%1
prompt We will now start the operation of saving the data of a device into a file.
delay \%1
prompt The first thing we need to do is to execute the command "Choose Device".
delay \%1
key c                               // Choose manufacturer AMD
prompt Now we have to select the AMD device manufacturer.
delay \%1
key 01
prompt We need to type <Enter> to bring up AMD's Device List.
delay \%1
key \enter
prompt To select the device AM2764 we will press the DOWN cursor key 3 times.
delay \%1
key \dn \dn \dn                     // Search device AM2764
prompt To select the PLCC package we can either press the <Space Bar> or type "j".
delay \%1
key j
prompt We will type now <Enter> to select the device and return to the Main Menu.
delay \%1
key \enter
prompt Here you would need to insert the deice AM2764 into the socket.
delay \%1
init autoblank y                    // Init autoblankcheck to y(es)
init autover s                      // Init autoverify to s(tandard)
init autochkins n                   // Init autocheckinsertion to n(o)
init autochkid n                    // Init autocheckid to n(o)
prompt Will execute "Read Device" command to read the device into the Edit Buffer.
delay \%1
key r                               // Read device into Edit Buffer
prompt Now execute "Save Buffer" to save the data from the Edit Buffer into file.
delay \%1
key a                               // Save Edit Buffer command
clrfield                            // Clear file name input field
prompt Here we will type the name of the file where we want to save the data.
delay \%1
key file1.dat                       // Insert file name FILE1.DAT
prompt Next we will hit <Enter> to start saving the file.
delay \%1
key \enter
prompt Type "y" to overwrite the existing file.
delay \%1
key y
prompt Finally we will type <ESC> to quit.
delay \%1
key \esc
prompt Typing "y" will confirm.
delay \%1
key y
endmac
// ----------------------------------------------------------------------------
 
 
MACRO DEMO3
// ----------------------------------------------------------------------------
// This macro selects the manufacturer AMD and device AM2764 and propmts you to
// insert device into socket and hit any key to continue. It then reads the
// device into Edit Buffer, save the Edit Buffer into file FILE1.DAT, selects
// the manufact. FUJITSU and device MBM27C64, prompts you insert the new device
// in the socket and hit any key to continue, after which it programs the device
// and verifies it with the data in Edit buffer.
// ----------------------------------------------------------------------------
key d
prompt Note1: If the slide show runs too slow you can change the Slide Show Speed.
delay \%1
prompt When back to [Execute Sample Operations] run command "Set Slide Show Speed".
delay \%1
prompt Note2: You can also step at any time to the next slide by tapping any key.
delay \%1
prompt Note3: PROTEUS-TUTOR messages are in yellow. Execution messages are in red.
delay \%1
prompt We will now start the operation of copying a device into a second device.
delay \%1
prompt We will start by executing the command "Choose Device".
delay \%1
key c                               // Choose manufacturer AMD
prompt Now we have to select the AMD device manufacturer.
delay \%1
key 01
prompt We need to type <Enter> to bring up AMD's Device List.
delay \%1
key \enter
prompt To select the device AM2764 we will press the DOWN cursor key 3 times.
delay \%1
key \dn \dn \dn                     // Search device AM2764
prompt To select the PLCC package we can either press the <Space Bar> or type "j".
delay \%1
key j
prompt We will type now <Enter> to select the device and return to the Main Menu.
delay \%1
key \enter
prompt You would now need to insert the device AM2764 in the socket.
delay \%1
init autoblank y                    // Init autoblankcheck to y(es)
init autover s                      // Init autoverify to s(tandard)
init autochkins n                   // Init autocheckinsertion to n(o)
init autochkid n                    // Init autocheckid to n(o)
prompt Will execute "Read Device" command to read the device into the Edit Buffer.
delay \%1
key r                               // Read device into Edit Buffer
prompt Next we will execute again the command "Choose Device" for the second device.
delay \%1
key c                               // Choose manufacturer AMD
prompt Now we have to select the Fujitsu device manufacturer.
delay \%1
key 11
prompt We need to type <Enter> to bring up Fujitsu's Device List.
delay \%1
key \enter
prompt To select the device MBM27C64 we will press the DOWN cursor key 5 times.
delay \%1
key \dn \dn \dn \dn \dn             // Select device MBM27c64
prompt We will type now <Enter> to select the device and return to the Main Menu.
delay \%1
key \enter
prompt You would need now to insert the device MBM27C64 in the socket.
delay \%1
prompt We will now set certain programming options.
delay \%1
key o                               // Execute Options command
prompt Now we will type <ESC> to return to the Main Menu.
delay \%1
key \esc
init autoblank y                    // Init autoblankcheck to y(es)
init autover s                      // Init autoverify to s(tandard)
init autochkins n                   // Init autocheckinsertion to n(o)
init autochkid n                    // Init autocheckid to n(o)
prompt Next we will execute "Program Device" to program from buffer to new device.
delay \%1
key p                               // Read device into Edit Buffer
prompt Finally we will type <ESC> to quit.
delay \%1
key \esc
prompt Typing "y" will confirm.
delay \%1
key y
endmac
// ----------------------------------------------------------------------------
 
 
 
MACRO NEWDEV
// ----------------------------------------------------------------------------
// This macro selects the Auxiliary Command Screen and executes the command
// View REVision File.
// ----------------------------------------------------------------------------
key d
key x \enter
key n \enter
prompt Hit <ESC> to return to the PROTEUS-TUTOR
loop 500
  getkey
  ifkey \ESC
    key \esc
    break
  endif
  ifkey \pgup
    key \pgup
  endif
  ifkey \pgdn
    key \pgdn
  endif
  ifkey \end
    key \end
  endif
  ifkey \home
    key \home
  endif
endloop
key \esc \esc y
endmac
// ----------------------------------------------------------------------------
 
 
MACRO DEVLIST
// ----------------------------------------------------------------------------
// This macro selects the Auxiliary Command Screen and executes the command
// View Device List
// ----------------------------------------------------------------------------
key d
key x \enter
key e \enter
prompt Hit <ESC> to return to PROTEUS-TUTOR
loop 500
  getkey
  ifkey \ESC
    key \esc
    break
  endif
  ifkey \pgup
    key \pgup
  endif
  ifkey \pgdn
    key \pgdn
  endif
  ifkey \end
    key \end
  endif
  ifkey \home
    key \home
  endif
endloop
key \esc \esc y
endmac
// ----------------------------------------------------------------------------
 
 
MACRO SLIDE1
// ----------------------------------------------------------------------------
// This macro runs a slide show of the PROTEUS commands
// ----------------------------------------------------------------------------
key d
loop 10
prompt Note1: If the slide show runs too slow you can change the Slide Show Speed.
delay \%1
prompt When back to [Get Familiar with PROTEUS] run command "Set Slide Show Speed".
delay \%1
prompt Note2: You can also step at any time to the next slide by tapping any key.
delay \%1
prompt Note3: PROTEUS-TUTOR messages are in yellow. Execution messages are in red.
delay \%1
prompt We will start to go through all the PROTEUS commands.
delay \%1
prompt This is the Main PROTEUS COMMANDS Menu.
delay \%1
prompt A command can be selected/highlighted by using the UP or DOWN cursor keys.
delay \%1
prompt To execute the selected (highlighted) command press <Enter>.
delay \%1
prompt There is an alternate way to select and execute a command.
delay \%1
prompt Notice that each command has a highlighted letter in its name.
delay \%1
prompt Typing that letter will select and immediately execute the command.
delay \%1
prompt The first thing to do is to select a device to operate on.
delay \%1
prompt To select a device from the Device Menu we execute "Choose Device".
delay \%1
key \enter
prompt Using the cursor keys or typing-in the number we select the manufacturer.
delay \%1
prompt We will select for example INTEL
delay \%1
key 17 \enter
prompt Now we have to select the device. If not shown on the screen use PgUP/PgDn.
delay \%1
prompt To select for example a 27C64 EPROM we hit PgDn and type "02".
delay \%1
key \pgdn 02
prompt The device package is selected by tapping the <Space> bar or typing the code.
delay \%1
prompt In our case we need the DIP(P) package so we just type "P".
delay \%1
key p
prompt We will now hit the <ENTER> key to return to the Main Menu.
delay \%1
key \enter
prompt An alternate way to select the device to work on is to search for it.
delay \%1
prompt If we know the device part number we select the "Search Device" command.
delay \%1
key \dn
prompt Typing <Enter> will execute the "Search Device" command.
delay \%1
key s
prompt Now we have to type-in the device part name we want to search for (D27C64).
delay \%1
key D27C64 \enter
prompt If the name doesn't uniquely define a device a list of devices is displayed.
delay \%1
prompt Using the cursor keys (UP/DN) highlight the desired device.
delay \%1
key \dn
prompt Typing <Enter> will perform the actual device selection.
delay \%1
key \enter
delay \%1
prompt Once a device is selected we can now read its contents into memory.
delay \%1
key \dn
prompt The command "Read Device" will copy the device contents into the Edit Buffer.
delay \%1
key r
prompt If no errors are encountered the Buffer data will now equal the device data.
delay \%1
prompt The Edit Buffer data can be viewed/altered with command "Edit Buffer Data".
delay \%1
prompt More on the "Edit Buffer Data" command later.
delay \%1
key \dn
prompt The next command is "Program Device". We select it with the cursor key.
delay \%1
prompt This command lets you program a device with the contents of the Edit Buffer.
delay \%1
prompt To execute it we just type <Enter>.
delay \%1
key p
prompt The selected device has now been programmed with the data in the Edit Buffer.
delay \%1
prompt The command "Verify Device" lets you verfiy a device against the Edit Buffer.
delay \%1
prompt We cursor down by one and hit <Enter> to execute it.
key \dn
delay \%1
key \enter
prompt The result of the "Verify Device" command is displayed on the screen.
delay \%1
prompt If no errors are encountered the device data is same as Buffer Data.
delay \%1
key \dn
prompt The following command is "Blankcheck Device". We can cursor down to it.
delay \%1
prompt This command checks if a device is blank (no memory locations programmed).
delay \%1
prompt We need to hit <Enter> to execute the command.
delay \%1
key b
prompt The result will be displayed on the screen.
delay \%1
key \dn
prompt The command "Illegal Check Bit" checks for illegal bits in the Edit Buffer.
delay \%1
key g
prompt The result is displayed on the screen.
delay \%1
// Firts Break ----------------------
prompt Note: To quit this Slide Show now type [Q], otherwise type any other key:_
getkey
ifkey q
  break
endif
key \dn
prompt The next command allows for the viewing and editing of the Edit Buffer.
delay \%1
key e
prompt Data can be input in HEX or in ASCII
delay \%1
key 313233
key \tab
key test
delay \%1
prompt Function keys are provided for various functions.
delay \%1
prompt After editing/ viewing the data you can return to Main Menu by typing <ESC>.
delay \%1
key \esc
key \dn
prompt Next command is "Load File" which lets you load a data file into the Buffer.
delay \%1
key l
prompt This is where you can select various file loading options including filename.
delay \%1
prompt The I/O format for example lets you select the format of the data file.
delay \%1
prompt One of the useful features is the (file) Auto detect option.
delay \%1
prompt This option, when set to "y" will automatically detect the type of the file.
delay \%1
prompt Type the file name in the top dat field and hit <Enter>
delay \%1
clrfield
key file1.dat
delay \%1
prompt We now type <Enter> to execute the command "Load File".
delay \%1
key \enter
prompt Back to the Main Menu. Next command is "Save Buffer".
delay \%1
key \dn
key a
prompt The "Save File" options screen looks similar with that in "Load File".
delay \%1
prompt The data transfer process is actually the same but reversed.
delay \%1
prompt Type-in the file name, set up options and type <Enter> to execute.
delay \%1
key \enter
delay \%1
prompt Overwrite the data file if desire.
delay \%1
key y
key \dn
prompt Back to the Main Menu. We will select now "Options".
delay \%1
key o
prompt This is where you can set all the programming and system options.
delay \%1
prompt You can press F1 when runnning in Normal Mode to get Help on all options.
delay \%1
prompt We will return now to the Main Menu by typing <Enter> or <ESC>
delay \%1
key \enter
// Second Break ----------------------
prompt Note: To quit this Slide Show now type [Q], otherwise type any other key:_
getkey
ifkey q
  break
endif
key \dn
prompt The Auxiliary Command can be accessed by executing "Auxiliary Commands".
delay \%1
key x
prompt The first Auxiliary Command is "Diagnostic and Calibration".
delay \%1
prompt Running this command will recalibrate and diagnose PROTEUS.
delay \%1
key \enter
prompt The various "View File" lets you inspect several relevant System Files.
delay \%1
prompt The "Change Color" command will let you change the screen color combination.
delay \%1
key c
prompt Type <ESC> to return to Auxiliary Command Menu
delay \%1
key \esc
prompt The Handler Commands are all related to operating PROTEUS with handlers.
delay \%1
prompt We will now type <ESC> to return to the Main Menu.
delay \%1
key \esc
delay \%1
break
endloop
prompt Typing <ESC> again and confirming with "y" will return us to PROTEUS-TUTOR.
delay \%1
key \esc y
endmac
// ----------------------------------------------------------------------------
 
 
 
MACRO SLIDE2
// ----------------------------------------------------------------------------
// This macro selects the Auxiliary Command Screen and executes the command
// View DOCumentation File
// ----------------------------------------------------------------------------
key d
key x \enter
key i \enter
prompt Hit <ESC> to return to PROTEUS-TUTOR
loop 500
  getkey
  ifkey \ESC
    key \esc
    break
  endif
  ifkey \pgup
    key \pgup
  endif
  ifkey \pgdn
    key \pgdn
  endif
  ifkey \end
    key \end
  endif
  ifkey \home
    key \home
  endif
endloop
key \esc \esc y
endmac
// ----------------------------------------------------------------------------
 
 
 
MACRO PROG1
// ----------------------------------------------------------------------------
// This macro selects the manufacturer AMD and device AM2764 and propmts you to
// insert device into socket and hit any key to continue. It then reads the
// device into Edit Buffer, save the Edit Buffer into file FILE1.DAT, selects
// the manufact. FUJITSU and device MBM27C64, prompts you insert the new device
// in the socket and hit any key to continue, after which it programs the device
// and verifies it with the data in Edit buffer.
// ----------------------------------------------------------------------------
key \f2 c \f4 amd \enter            // Go to Main Menu (f2), search manuf AMD
key \f4 am2764 \enter               // Search device AM2764
prompt Insert device AM2764 in socket and press any key to continue.
getkey                              // Wait until key is pressed
init autoblank y                    // Init autoblankcheck to y(es)
init autover s                      // Init autoverify to s(tandard)
init autochkins n                   // Init autocheckinsertion to n(o)
init autochkid n                    // Init autocheckid to n(o)
init autoblank y                    // Init autoblank check to y(es)
key r                               // Read device into Edit Buffer
key a                               // Save Edit Buffer command
clrfield                            // Clear file name input field
key file1.dat \enter                // Insert file name FILE1.DAT
prompt Insert device MBM2764 in socket and press any key to continue.
getkey                              // Wait unti key is pressed
key c \f4 fujitsu \enter            // Search manufact. Fujistu
key \f4 mbm2764 \enter              // Search device MBM26C64
key p                               // Program device
key v                               // Verify device
prompt Hit <ESC> to exit the Macro Command Line or type-in another macro.
endmac
// ----------------------------------------------------------------------------
 
 
 
 
MACRO PROG2
// ----------------------------------------------------------------------------
// This macro is doing the same as the macro PROG1 only with the normal Proteus
// screen turned OFF.
// ----------------------------------------------------------------------------
scrnoff                             // Turn Proteus screen OFf
key \f2 c \f4 amd \enter            // Go to Main Menu (f2), search manuf AMD
key \f4 am2764 \enter               // Search device AM2764
prompt
prompt >>> Insert device AM2764 in socket and press any key to continue:_
getkey                              // Wait until key is pressed
init autoblank y                    // Init autoblankcheck to y(es)
init autover s                      // Init autoverify to s(tandard)
init autochkins n                   // Init autocheckinsertion to n(o)
init autochkid n                    // Init autocheckid to n(o)
init autoblank y                    // Init autoblank check to y(es)
key r                               // Read device into Edit Buffer
key a                               // Save Edit Buffer command
clrfield                            // Clear file name input field
key file1.dat \enter                // Insert file name FILE1.DAT
prompt
prompt >>> Insert device MBM2764 in socket and press any key to continue:_
getkey                              // Wait unti key is pressed
key c \f4 fujitsu \enter            // Search manufact. Fujistu
key \f4 mbm2764 \enter              // Search device MBM26C64
key p                               // Program device
key v                               // Verify device
scrnon                              // Turn screen back on
prompt Hit <ESC> to exit the Macro Command Line or type-in another macro.
endmac
// ----------------------------------------------------------------------------
 
 
MACRO PROG3
// ----------------------------------------------------------------------------
// This macro is doing the same as the macro PROG1 only it exits the Proteus
// program upon completion, exemplifying how to run a macro from a DOS batch
// program. (See file DEMO.BAT)
// ----------------------------------------------------------------------------
key d                               // Set-up PROTEUS to operate in DEMO mode
init autocal n                      // Init autocalibration to n(o)
delay 1000
key \f2 c \f4 amd \enter            // Go to Main Menu (f2), search manuf AMD
delay 1000
key \f4 am2764 \enter               // Search device AM2764
delay 1000
prompt
prompt >>> Insert device AM2764 in socket and press any key to continue:_
delay 1000
getkey                              // Wait until key is pressed
init autoblank y                    // Init autoblankcheck to y(es)
init autover s                      // Init autoverify to s(tandard)
init autochkins n                   // Init autocheckinsertion to n(o)
init autochkid n                    // Init autocheckid to n(o)
init autoblank y                    // Init autoblank check to y(es)
key r                               // Read device into Edit Buffer
delay 1000
key a                               // Save Edit Buffer command
delay 1000
clrfield                            // Clear file name input field
delay 1000
key file1.dat \enter                // Insert file name FILE1.DAT
delay 2000
prompt
prompt >>> Insert device MBM2764 in socket and press any key to continue:_
delay 1000
getkey                              // Wait unti key is pressed
key c \f4 fujitsu \enter            // Search manufact. Fujistu
delay 2000
key \f4 mbm2764 \enter              // Search device MBM26C64
delay 1000
key p                               // Program device
delay 1000
key v                               // Verify device
delay 1000
key \esc y \enter                   // Terminate program
endmac
// ----------------------------------------------------------------------------
 
 
MACRO PROG4
// ----------------------------------------------------------------------------
// This macro is doing the same as the macro PROG3 only it turns the normal
// PROTEUS screen OFF, for a simpler and less confusing operation by an
// inexperienced user. (See file DEMO.BAT)
// ----------------------------------------------------------------------------
scrnoff                             // Turn normal PROTEUS screen OFF
key d                               // Set-up PROTEUS to operate in DEMO mode
init autocal n                      // Init autocalibration to n(o)
key \f2 c \f4 amd \enter            // Go to Main Menu (f2), search manuf AMD
key \f4 am2764 \enter               // Search device AM2764
prompt
prompt >>> Insert device AM2764 in socket and press any key to continue:_
getkey                              // Wait until key is pressed
init autoblank y                    // Init autoblankcheck to y(es)
init autover s                      // Init autoverify to s(tandard)
init autochkins n                   // Init autocheckinsertion to n(o)
init autochkid n                    // Init autocheckid to n(o)
init autoblank y                    // Init autoblank check to y(es)
key r                               // Read device into Edit Buffer
key a                               // Save Edit Buffer command
clrfield                            // Clear file name input field
key file1.dat \enter                // Insert file name FILE1.DAT
prompt
prompt >>> Insert device MBM2764 in socket and press any key to continue:_
getkey                              // Wait unti key is pressed
key c \f4 fujitsu \enter            // Search manufact. Fujistu
key \f4 mbm2764 \enter              // Search device MBM26C64
key p                               // Program device
key v                               // Verify device
key \esc y \enter                   // Terminate program
endmac
// ----------------------------------------------------------------------------
 
 
MACRO PROG5
// ----------------------------------------------------------------------------
// This macro selects the manufacturer and part given as parameter, loads data
// file given as third parameter into the Edit buffer, initializes programming
// parameters and then programs & verifies the device with data in Edit buffer.
// ----------------------------------------------------------------------------
key \f2 c \f4 \%1 \enter            // Main Menu (f2), search manuf (param #1)
key \f4 \%1 \enter                  // search device (params #2)
key l                               // Load file command
clrfield                            // Clear file name input field
key \%2 \enter                      // Insert file name (param #3)
init autoblank y                    // Initialize progr params
init autover s
init autochkins n
init autochkid n
init autoblank y
key p                               // Program device
key v                               // Verify device
prompt Hit <ESC> to exit the Macro Command Line or type-in another macro.
endmac
// ----------------------------------------------------------------------------
 
MACRO SERIALIZE
// ----------------------------------------------------------------------------
// This macro accepts on the command line a parameter used to initialize the
// serial number and repeats for 500 times the operation of serializing EPROMs.
// This is done by programming at a specific address the current serial number,
// and then incrementing the serial number for the next serialization operation.
// ----------------------------------------------------------------------------
scrnoff                             // Turn screen off
init serial# \%1                    // Initialize Serial #.
loop 500                            // Do for 500 devices
  key e                             // Go into edit buffer
  key \F3 00000D \Enter             // Go to address for Serial #
  key \serial#6                     // Insert Serial #.
  key \esc                          // Return to Main Menu
  prompt Program \serial#6 (Y/N)?_  // Prompt user to serialize
  getkey                            // Read key input by user
  ifkey n                           // If user responds 'N' exit loop
    break
  endif                             // Program device
  key p
  iferr
  else
    inc serial#                     // If no errors increment serial #
  endif
endloop                             // Repeat for next device
key \esc y                          // Return to DOS
endmac
// ----------------------------------------------------------------------------
 
 
MACRO LOAD
// Loads a file to the data buffer. Syntax: "load <filename> <enter>"
key l
clrfield
key \%1 \enter
endmac
// ----------------------------------------------------------------------------
MACRO SELECT
// Selects a device from lib. Syntax: "select <manuf> <partnum> <enter>"
key \F2 C \F4 \%1 \enter
iferr
     ret
endif
key \F4 \%2 \enter
endmac
// ----------------------------------------------------------------------------
MACRO SELPLCC
KEYBOARD \F2 CP \F4 \%1 \ENTER
IFERR
     RET
ENDIF
KEYBOARD \F4 \%2 \ENTER
ENDMAC
// ----------------------------------------------------------------------------
MACRO EDIT
KEYBOARD \F2 L
CLRFIELD
KEYBOARD \%1 \ENTER
IFERR
     RET
ENDIF
KEYBOARD \F2 E
ENDMAC
// ----------------------------------------------------------------------------
MACRO PROG
KEYBOARD \F2 L \%1 \ENTER
IFERR
     RET
ENDIF
KEYBOARD \ESC P
ENDMAC
// ----------------------------------------------------------------------------
MACRO READ
KEYBOARD \F2 R
IFERR
     RET
ENDIF
KEYBOARD S \%1 \ENTER
IFERR
     RET
ENDIF
KEYBOARD \ESC
ENDMAC
// ----------------------------------------------------------------------------
MACRO VER
KEYBOARD \F2 L \%1 \ENTER
IFERR
     RET
ENDIF
KEYBOARD \ESC V
ENDMAC
// ----------------------------------------------------------------------------
MACRO LOAD
KEYBOARD \F2 L \%1 \ENTER
IFERR
     RET
ENDIF
KEYBOARD \ESC
ENDMAC
// ----------------------------------------------------------------------------
MACRO SAVE
KEYBOARD \F2 S
CLRFIELD
KEYBOARD \%1 \ENTER
IFERR
     RET
ENDIF
ENDMAC
// ----------------------------------------------------------------------------
MACRO FILL
KEYBOARD \F5 \%1 \DN \%2 \DN \%1 \ENTER
ENDMAC
// ----------------------------------------------------------------------------
MACRO GOTO
KEYBOARD \F3 \%1 \ENTER
ENDMAC
// ----------------------------------------------------------------------------
MACRO INSERT
KEYBOARD \INSERT
ENDMAC
// ----------------------------------------------------------------------------
MACRO TAB
KEYBOARD \TAB
ENDMAC
// ----------------------------------------------------------------------------
MACRO CLRFIELD
KEYBOARD \BS \BS \BS \BS \BS \BS \BS \BS \BS \BS \BS \BS \BS \BS \BS \BS \BS \BS \BS \BS
KEYBOARD \BS \BS \BS \BS \BS \BS \BS \BS \BS \BS \BS \BS \BS \BS \BS
ENDMAC
// ----------------------------------------------------------------------------
MACRO ESCAPE
KEYBOARD \ESC
ENDMAC
// ----------------------------------------------------------------------------
MACRO EDITOLD
KEYBOARD \ESC \F6
ENDMAC
// ----------------------------------------------------------------------------
MACRO EDITNEW
KEYBOARD \ESC \F7
ENDMAC
// ----------------------------------------------------------------------------
MACRO EDITFILE
// Calls editor \dos\edit.com with file to edit 'file1.dat'
CALL \dos\edit file1.dat
ENDMAC
// ----------------------------------------------------------------------------
MACRO EDITMCR
CALL x proteus.mcr
ENDMAC
// ----------------------------------------------------------------------------
 
 
 
Macro_Program
// ----------------------------------------------------------------------------
// All macrocommands and macros below this line are executed upon running the
// PROTEUS.EXE program.
// ----------------------------------------------------------------------------
// Assign <CTRL> F# keys to macros;  To run type <CTRL F#> from Main Menu.
  SETKEY ^F1 EDITMCR
  SETKEY ^F2 EDITFILE
  SETKEY ^F7 EDITOLD
  SETKEY ^F8 EDITNEW
// ----------------------------------------------------------------------------
